%define module_name Net-DAVTalk
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime/Format/ISO8601.pm) perl(DateTime/TimeZone.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Tiny.pm) perl(JSON.pm) perl(JSON/XS.pm) perl(Test/More.pm) perl(Tie/DataUUID.pm) perl(URI.pm) perl(XML/Fast.pm) perl(XML/Spice.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.23
Release: alt1
Summary: Interface to talk to DAV servers
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BR/BRONG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Net::DAVTalk is was originally designed as a service module for Net::CalDAVTalk
and Net::DAVTalk, abstracting the process of connecting to a DAV server and
parsing the XML responses.

Example:

    use Net::DAVTalk;
    use XML::Spice;

    my $davtalk = Net::DAVTalk->new(
        url => "https://dav.example.com/",
        user => "foo\@example.com",
        password => "letmein",
    );

    $davtalk->Request(
        'MKCALENDAR',
        "$calendarId/",
        x('C:mkcalendar', $Self->NS(),
            x('D:set',
                 x('D:prop', @Properties),
            ),
        ),
    );

    $davtalk->Request(
        'DELETE',
        "$calendarId/",
    );
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/N*

%changelog
