# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Net/ARP.pm) perl(Net/PcapUtils.pm) perl(Net/RawIP.pm) perl(NetPacket/ARP.pm) perl(NetPacket/Ethernet.pm) perl(NetPacket/IP.pm) perl(NetPacket/UDP.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Net-DHCPClientLive
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: stateful DHCP client object
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MINGZHANG/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Net::DHCPClientLive allows you to create and manipulate DHCP client(s) so that you
can test the behavior of your DHCP server upon client state transition.

DHCP client is a stateful host. It reaches "BOUND" state after the successful discover
process, and will renew and/or rebind when T1/T2 timer expire. The state will be changed
accordingly depending on the behavior of the server.

With this module you can move client's state, make transition, and even let it go freely.
At each attempt of operation, it can tell whether it success or fail, so that you know
if your server works as expected.

You can create many DHCP clients at the same time. In this way you can easily execute
scalability test. Image you create 100 live DHCP clients, they are alive as though there
were 100 hosts there, doing renew, rebind, or release interacting with your DHCP server
for a few days, just like they do in real scenario.

I also provide some code showing how to do this in EXAMPLES section.

Client identifier
   - mac address is the identifier of a client, it's assigned when created and kept in the whole life cycle
   - xid is kept in the client life cycle until back to INIT, when xid is initialized

The following is the detail description of state transition.
   INIT->SELECT  
      send DISCOVER, receive OFFER, check and report, 
      return true if receiving DHCP OFFER from server, or false if no OFFER received.
      The state of client moves to SELECT anyway.


   INIT->REQUEST 
   SELECT->REQUEST 
      send DISCOVER, receive OFFER, and send REQUEST, check ACK and report,
      return true if receiving both DHCP OFFER and ACK from server, or false otherwise
      The state of client moves to SELECT if no OFFER received or REQUEST if OFFER received.

   SELECT->SELECT
      same as INIT->SELECT, 
      this allows you to test intensively the server response to DISCOVER

   REQUEST->REQUEST
      same as SELECT->REQUEST, 
      this allows you to test intensively the server response to DISCOVER/REQUEST


   INIT->BOUND 
      send DISCOVER, receive OFFER, and send REQUEST, receive ACK and update.
      return true only if the whole process correct.
      The state of client moves accordingly to SELECT, REQUEST, or BOUND
      SELECT if client sends DISCOVER
      REQUEST if client receives OFFER, then sends REQUEST
      BOUND if client receives ACK after sending REQUEST

   SELECT->BOUND
      back to INIT, then same to above

   REQUEST->BOUND
      send REQUEST, receive ACK and update (because client already has server offer info in obj)
      return true only if the client receives ACK.
      The state of client moves to BOUND if receives ACK, or stay at REQUEST if no ACK

   BOUND->BOUND 
      Simulates T1 expire. Sends unicast REQUEST to server, and move to RENEW
      move to BOUND and refresh lease after receiving ACK from server
      return true if receives ACK
      Note: Linux server sends ARP request to client ip, client has to replay this ARP
         before Linux server sends ACK

   RENEW->BOUND
   REBIND->BOUND
      Simulates T2 expire. sends broadcase REQUEST, move to BOUND and refresh lease if receives ACK
      return true if receives ACK


   BOUND->RENEW
      Simulates T1 expire. Sends unicast REQUEST to server, and move to RENEW
      return true if receives ACK 
      Note: Linux server sends ARP request to client ip, client also replay this ARP
         before Linux server sends ACK

   BOUND->REBIND
      Does BOUND->RENEW first
      Then ignore ACK and does RENEW->REBIND

   RENEW->REBIND
      Simulates T2 expire. sends broadcase REQUEST
      return true if receives ACK to this broadcase REQUEST


   REBIND->INIT
   RENEW->INIT
      Sends RELEASE and move to INIT

 
   RENEW->SELECT  
   RENEW->REQUEST
   REBIND->SELECT
   REBIND->REQUEST

      1. ->INIT
      2. INIT->REQUEST


   undef->INIT
      do nothing

   SELECT->INIT
      clear XID

   REQUEST->INIT 
      send DECLINE, clear XID



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/N*

%changelog
