%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(Net/DNS.pm) perl(Net/DNS/RR.pm) perl(NetAddr/IP.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 2.00
%define module_name Net-DNS-Method
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.00
Release: alt1
Summary: Base class for Net::DNS::Server methods
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/L/LU/LUISMUNOZ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a base class to help in the creation of method classes for use
within the Net::DNS::Server package. This class provides specific methods
to do nothing to particular DNS questions. In general, this class consists
of a number of methods that are called like in the following example.

=over

=item `->A($q, $ans)'

This would be invoked by Net::DNS::Server upon the arrival of a query
of type 'A'.

=back

The method can check the question, passed as a Net::DNS::Qustion
object in `$q'. Usually, the method will then modify the
Net::DNS::Packet object in `$ans' to provide an answer.

Net::DNS::Server will call sequentially all of the registered
Net::DNS::Method::* objects for a given question. After this sequence
of calls ends, the response can be sent depending on what the methods
have requsted.

The return value of the method is given as an OR of the following
values.

=over

=item `NS_IGNORE'

Requests that the current question be ignored.

=item `NS_STOP'

Requests that no further objects be invoked.

=item `NS_OK'

Indicates that the current method matched the question and presumably,
altered the answer. Control is passed to the next method in
sequence. After the last method is invoked, the answer will be sent to
the client unless `NS_IGNORE' is returned by this or a later method.

=item `NS_FAIL'

Indicates that the current method did not match the packet.

=item `NS_SPLIT'

Indicates that the response must be splitted in individual answers and
sent accordingly. This is used for AXFR requests.

=back

There is one such method for each type of RR supported by
the Net::DNS manpage. Additionally, the `->ANY' method is provided, which
calls all the defined RRs in succession.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO README
%perl_vendor_privlib/N*

%changelog
