%define module_version 1.0.3
%define module_name Net-Dogstatsd
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(Data/Validate/Type.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/INET.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Net/Telnet.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/FailWarnings.pm) perl(Test/Most.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.3
Release: alt1
Summary: Perl client to Datadog's dogstatsd metrics collector.
Group: Development/Perl
License: gpl
URL: https://metacpan.org/release/Net-Dogstatsd

Source0: http://cpan.org.ua/authors/id/J/JP/JPINKHAM/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module allows you to send multiple types of metrics to the Datadog service
via dogstatsd, a local daemon installed by Datadog agent package.

_use Net::Dogstatsd;

_# Create an object to communicate with Dogstatsd, using default server/port settings.
_my $dogstatsd = Net::Dogstatsd->new(
__host    => 'localhost',  #optional. Default = 127.0.0.1
__port    => '8125',       #optional. Default = 8125
__verbose => 0,            #optional. Default = 0
_);
_
_# Set, and print, the 'verbose' option value.
_$dogstatsd->verbose(1);
_print "In verbose mode." if $dogstatsd->verbose();
_
_# Before we can start sending metrics, we have to get or create a socket to dogstatsd
_my $socket = $dogstatsd->get_socket();
_
_# Counter metrics can be incremented or decremented
_# By default, they will be incremented or decremented by 1, unless the optional
_# 'value' parameter is passed
_$dogstatsd->increment(
__name  => 'test_metric.sample_counter',
__value => $increment_value, #optional; default = 1
__tags  => [ 'env:production', db ], #optional
_);
_
_$dogstatsd->decrement(
__name  => $metric_name,
__value => $decrement_value, #optional; default = 1
__tags  => [ 'env:devel', web ], #optional
_);
_
_
_# Gauge metrics can be used for capturing value of something over time
_# Example: Gas gauge, inventory level, free memory
_$dogstatsd->gauge(
__name  => 'test_metric.inventory_level',
__value => $gauge_value, #required - must be a number
__tags  => [ 'warehouse:us' ], #optional
_);
_
_
_# Histogram metrics measure the statistical distribution of a set of values.
_# Provides min/max/avg as well as 75th, 85th, 95th and 99th percentiles.
_# NOTE: do not use this for timers. Use timer() instead.
_$dogstatsd->histogram(
__name  => $metric_name,
__value => $value,
__tags  => [ 'tag1', 'tag2:value', 'tag3' ], #optional
_);
_
_
_# Timers are a special type of histogram. 
_$dogstatsd->timer(
__name  => $metric_name,
__value => $metric_value,
__unit  => $metric_unit, # 'ms' (milliseconds) or 's|sec' (seconds)
__tags  => [ 'tag1', 'tag2:value', 'tag3' ], #optional
_);
_
_
_# Set metrics are special counters that can track unique elements in a group.
_# Example: the number of unique visitors currently on a website
_$dogstatsd->sets(
__name  => 'unique.site_visitors',
__value => $account_id,
__tags  => [ 'referer:Google' ], #optional
_);
_

%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE examples
%perl_vendor_privlib/N*

%changelog
