Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform tests that access the Internet.
%bcond_with perl_Net_FTP_RetrHandle_enables_network_test

%global         cpan_name Net-FTP-RetrHandle
Name:           perl-%{cpan_name}
Version:        0.2
Release:        alt3_36
Summary:        File reading interface for reading files on a remote FTP server
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/%{cpan_name}
Source0:        https://cpan.metacpan.org/authors/id/G/GI/GIFF/%{cpan_name}-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(IO/Seekable.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
%if %{with perl_Net_FTP_RetrHandle_enables_network_test}
BuildRequires:  perl(Fcntl.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(Net/FTP.pm)
BuildRequires:  perl(Symbol.pm)
%endif
BuildRequires:  perl(Test/More.pm)


Source44: import.info

%description
This Perl module provides a file reading interface for reading all or parts of
files located on a remote FTP server, including emulation of seek and support
for downloading only the parts of the file requested.

Support for skipping the beginning of the file is implemented with the FTP REST
command, which starts a retrieval at any point in the file. Support for
skipping the end of the file is implemented with the FTP ABOR command, which
stops the transfer. With these two commands and some careful tracking of the
current file position, we're able to reliably emulate a seek/read pair, and get
only the parts of the file that are actually read.

This was originally designed for use with Archive::Zip; it's reliable enough
that the table of contents and individual files can be extracted from a remote
ZIP archive without downloading the whole thing.

An interface compatible with IO::Handle is provided, along with a tie-based
interface.

%prep
%setup -q -n %{cpan_name}-%{version}
# Remove any CVS files
find -type d -name CVS -exec rm -rf {} +
perl -i -ne 'print $_ unless m{/CVS/}' MANIFEST
# Remove network tests
%if !%{with perl_Net_FTP_RetrHandle_enables_network_test}
for T in t/10remote.t t/11tie.t; do
  rm "$T"
  perl -i -ne 'print $_ unless m{^'"$T"'}' MANIFEST
done
%endif

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc TODO NEWS
%{perl_vendor_privlib}/*

%changelog
