Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Net-FTPServer
Version:        1.125
Release:        alt2_30
Summary:        Secure, extensible and configurable Perl FTP server
License:        GPL-2.0-or-later
URL:            https://metacpan.org/release/Net-FTPServer
Source0:        https://cpan.metacpan.org/authors/id/R/RY/RYOCHIN/Net-FTPServer-%{version}.tar.gz
# Increase default data segment size limit, bug #1381649
Patch0:         Net-FTPServer-1.125-Increase-default-memory-limit.patch
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Carp/Heavy.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(DBI.pm)
BuildRequires:  perl(Errno.pm)
BuildRequires:  perl(Fcntl.pm)
BuildRequires:  perl(FileHandle.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(IO/Dir.pm)
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(IO/Scalar.pm)
BuildRequires:  perl(IO/Seekable.pm)
BuildRequires:  perl(IO/Select.pm)
BuildRequires:  perl(IO/Socket.pm)
BuildRequires:  perl(IPC/Open2.pm)
BuildRequires:  perl(Net/FTP.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Sys/Hostname.pm)
BuildRequires:  perl(Sys/Syslog.pm)
BuildRequires:  perl(vars.pm)
# Optional run-time:
BuildRequires:  perl(Archive/Zip.pm)
BuildRequires:  perl(Authen/PAM.pm)
BuildRequires:  perl(BSD/Resource.pm)
BuildRequires:  perl(Digest/MD5.pm)
BuildRequires:  perl(File/Sync.pm)
# Tests:
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IO/Socket/INET.pm)
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests:
BuildRequires:  perl(Compress/Zlib.pm)
BuildRequires:  %{_bindir}/uudecode
BuildRequires:  %{_bindir}/compress
# Optional run-time:
Requires:       perl(Archive/Zip.pm)
Requires:       perl(Authen/PAM.pm)
Requires:       perl(BSD/Resource.pm)
Requires:       perl(Digest/MD5.pm)
Requires:       perl(File/Sync.pm)
Requires:       perl(IO/Scalar.pm) >= 1.126

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(IO.Scalar.pm)/d

%description
Net::FTPServer is a secure, extensible and configurable FTP server
written in Perl.

This package contains the Perl modules. Install the perl-ftpd package for
the server executables.

%package -n perl-ftpd
Group: System/Servers
Summary:        Secure, extensible and configurable Perl FTP server
Requires:       %{name} = %{version}-%{release}

%description -n perl-ftpd
Net::FTPServer is a secure, extensible and configurable FTP server
written in Perl.

This package contains server executables.

%prep
%setup -q -n Net-FTPServer-%{version}
%patch0 -p1

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} $RPM_BUILD_ROOT

# Daemon configuration file
install -m 644 -D etc/ftpd.conf $RPM_BUILD_ROOT%{_sysconfdir}/ftpd.conf

# Want the daemon in sbin rather than bin
[ ! -d $RPM_BUILD_ROOT%{_sbindir} ] \
    && mv -f $RPM_BUILD_ROOT%{_bindir} $RPM_BUILD_ROOT%{_sbindir}

%check
make test

%files
%doc AUTHORS Changes COPYING README TODO doc/
%{perl_vendor_privlib}/Net/

%files -n perl-ftpd
%config(noreplace) %{_sysconfdir}/ftpd.conf
%{_sbindir}/dbeg1-ftpd.pl
%{_sbindir}/ftpd.pl
%{_sbindir}/inmem-ftpd.pl
%{_sbindir}/proxy-ftpd.pl
%{_sbindir}/ro-ftpd.pl

%changelog
