# BEGIN SourceDeps(oneline):
BuildRequires: perl(LWP/Simple.pm)
# END SourceDeps(oneline)
%define module_name Net-IANA-TLD
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: IANA TLDs database
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WE/WESLEY/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
IANA TLDs database


    use Net::IANA::TLD;

    # for each new(), the latest TLD data will be downloaded from IANA's website
    # you should cache the object
    my $tld = Net::IANA::TLD->new();

    print $tld->version, "\n";
    print $tld->date, "\n";
    print $tld->size, "\n";

    # validate if a given TLD exists
    my $given_tld = "com";
    print "The TLD $given_tld exists\n" if $tld->has_tld($given_tld);


    # dump all tlds
    use Data::Dumper;
    my $hash_ref = $tld->tlds;
    print Dumper $hash_ref;

%prep
%setup -q -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes ignore.txt
%perl_vendor_privlib/N*

%changelog
