# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/Krb5/Easy.pm) perl(File/Spec/Functions.pm) perl(HTTP/Cookies.pm) perl(HTTP/Headers.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(LWP/Authen/Negotiate.pm) perl(LWP/UserAgent.pm)
# END SourceDeps(oneline)
%define module_version 1.0
%define module_name Net-IPA
BuildRequires: unzip
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary:  Perl 5 interface of the (Free)IPA JSON-RPC API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NI/NICKCIS/%{module_name}-%{module_version}.zip
BuildArch: noarch

%description
use Net::IPA;

  my $ipa = new Net::IPA(
    hostname => 'ipa.server.com',
    cacert => '/etc/ipa/ca.cert',
  );

  # (a) Login can be done via Kerberos
  $ipa->login();

  # (b) Login can be done via Kerberos (creating the ticket)
  $ipa->login(
    username => 'admin',
    keytab => '/etc/ipa/admin.keytab'
  );

  # (c) Login can be done using username and password
  $ipa->login(
    username => 'admin',
    password => 'admin-password'
  );

  # Control error
  die $ipa->error if($ipa->error);

  # $user_show is of the type Net::IPA::Response
  my $user_show = $ipa->user_show('username');
  die 'Error: ' . $user_show->error_string() if($user_show->is_error);

  # Requests can be batched
  use Net::IPA::Methods;
  my @users_show = $ipa->batch(
    Net::IPA::Methods::user_show('username1'),
    Net::IPA::Methods::user_show('username2'),
    Net::IPA::Methods::user_show('username3'),
  );

  foreach my $user_show (@users_show){
    # $user_show is of the type Net::IPA::Response
    if($user_show->is_error){
        print 'Error: ' . $user_show->error_string() . "\n";
        next;
    }

    # Do something
  }

For methods look at the the Net::IPA::Methods manpage module.
%prep
%setup -q -n perl-%{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE.md
%perl_vendor_privlib/N*

%changelog
