%define module_name Net-IPAM-Block
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Net/IPAM/IP.pm) perl(Scalar/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 6.01
Release: alt1
Summary: A library for reading, formatting, sorting and converting IP-blocks.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GA/GAISSMAI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A block is an IP-network or IP-range, e.g.

 192.168.0.1/24              # network, with CIDR mask
 ::1/128                     # network, with CIDR mask
 10.0.0.3-10.0.17.134        # range
 2001:db8::1-2001:db8::f6    # range

The parsed block is represented as an object with:

 base
 last
 mask    # if block is a CIDR, otherwise undef

This representation is fast sortable without conversions to/from the different IP versions.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/N*

%changelog
