%define module_name Net-IPAM-IP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 4.01
Release: alt1
Summary: A library for reading, formatting, sorting and converting IP-addresses.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GA/GAISSMAI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Net::IPAM::IP;

_# parse and normalize
_$ip1 = Net::IPAM::IP->new('1.2.3.4') // die 'wrong format,';
_$ip2 = Net::IPAM::IP->new('fe80::1') // die 'wrong format,';

_$ip3 = $ip2->incr // die 'overflow,';

_say $ip1;    # 1.2.3.4
_say $ip2;    # fe80::1
_say $ip3;    # fe80::2

_say $ip1->cmp($ip2);    # -1

_say $ip2->expand;       # fe80:0000:0000:0000:0000:0000:0000:0001
_say $ip2->reverse;      # 1.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.8.e.f

_$ip = Net::IPAM::IP->new_from_bytes(pack('C4', 192, 168, 0, 1));       # 192.168.0.1
_$ip = Net::IPAM::IP->new_from_bytes(pack('N4', 0x20010db8, 0, 0, 1,)); # 2001:db8::1

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/N*

%changelog
