%define module_name Net-Inspect
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Compress/Raw/Zlib.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(IO/Uncompress/Brotli.pm) perl(Net/Pcap.pm) perl(Net/PcapWriter.pm) perl(Net/SIP.pm) perl(Scalar/Util.pm) perl(Socket6.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.331
Release: alt1
Summary: library for inspection of data on various network layers
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SU/SULLR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The idea of the Net::Inspect manpage is to plug various layers of network inspection.together to analyze data.
This is kind of what wireshark or IDS do, exept this is in perl and
therefore slower to execute but faster to develop and maybe more flexibel
too.

One can start analysis on some level and stop it at any higher level.
There are various useful tools in tools/ which make use of this library:

=over 4

=item tcpflow

gets data from pcap file or does live capture and extracts tcp connections
into separate files.

=item httpflow

gets data from pcap file or does live capture and extracts http requests
into separate files. Does request unchunking and decompression. Works with
persistant and with pipelined HTTP connections.

=item http_inspection_proxy

simple http(s) proxy with the ability to inspect and transform requests.
Contrary to the tcpflow manpage and the httpflow manpage it starts analysis at the TCP
layer, not at the pcap layer.

Because of non-blocking DNS lookups and connects and DNS caching the proxy
is fast enough to be used in simple production setups. It can also store
each http connections as a single pcap file for more analysis.

=back

Currently the following modules are implemented:

=over 4

=item the Net::Inspect::L2::Pcap manpage

reads from pcap layer

=item the Net::Inspect::L3::IP manpage

processes raw IP packets, does defragmentation.

=item the Net::Inspect::L4::TCP manpage

handles TCP connections, e.g. connection setup and shutdown and reordering
of packets.

=item the Net::Inspect::L4::UDP manpage

handles UDP packets. Can aggregate udp packets in virtual connections.

=item the Net::Inspect::L5::GuessProtocol manpage

tries to guess the higher level protocol from TCP connections.

=item the Net::Inspect::L7::HTTP manpage

handles HTTP connections. Plugable into the Net::Inspect::L5::GuessProtocol manpage.

=item the Net::Inspect::L5::Null manpage

handles connections which don't transport any data.
Plugable into the Net::Inspect::L5::GuessProtocol manpage.

=item the Net::Inspect::L5::Unknown manpage

used together with the Net::Inspect::L5::GuessProtocol manpage as a fallback if no
other protocol handler matched.

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT README Changes
%perl_vendor_privlib/N*

%changelog
