%define module_version 0.04
%define module_name Net-JBoss
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(LWP/UserAgent.pm) perl(Log/Log4perl.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(URL/Encode.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Bindings for JBoss Management API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HE/HEINCE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use Net::JBoss::Management;

 my %%con = (
            username                => 'admin',
            password                => 'password',
            server                  => 'jboss1.example.com',
            port                    => 9443,                    #optional, default is 9990
            ssl                     => 'on',                    #optional, default is 'off'
            ssl_verify              => 'yes',                   #optional, default is 'no'
            realm                   => 'ManagementRealmHTTPS'   #optional, default is 'ManagementRealm'
 );

 my $jboss              = Net::JBoss::Management->new(%%con);
 
 my $state              = $jboss->get_state();
 my $jvm_usage          = $jboss->get_jvm_usage();
 my $runtime_stats      = $jboss->get_runtime_stats();
 my $deploy_info        = $jboss->get_deployment_info();
 my $app_runtime_stats  = $jboss->get_app_runtime_stats('hawtio.war');
 my $runtime_details    = $jboss->get_runtime_details();
 my $app_status         = $jboss->get_app_status('hawtio.war');
 my $active_session     = $jboss->get_active_sessions('hawtio.war');
 my $server_env         = $jboss->get_server_env();
 my $datasources        = $jboss->get_datasources();
 my $test               = $jboss->test_con_pool('ExampleDS');
 my $pool_stats         = $jboss->get_ds_pool_stats('java:jboss/datasources/jboss_Pool');
 my $enable_pool_stats  = $jboss->get_ds_pool_stats('java:jboss/datasources/jboss_Pool', 'true');
 my $disable_pool_stats = $jboss->get_ds_pool_stats('java:jboss/datasources/jboss_Pool', 'false');
 my $min_pool_size      = $jboss->set_ds_pool_size('min', 'java:jboss/datasources/jboss_Pool', 20);
 my $max_pool_size      = $jboss->set_ds_pool_size('max', 'java:jboss/datasources/jboss_Pool', 50);
 my $jndi               = $jboss->get_jndi();
 my $loglevel           = $jboss->get_log_level('CONSOLE');
 my $loglevel           = $jboss->set_log_level('CONSOLE', 'ERROR');
 my $reload             = $jboss->reload();
 my $shutdown           = $jboss->shutdown();
 my $restart            = $jboss->restart();
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/N*

%changelog
