# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/XSAccessor.pm) perl(ExtUtils/MakeMaker.pm) perl(Net/NATS/Client.pm) perl(Net/NATS/Streaming/PB.pm) perl(Scalar/Util.pm) perl(UUID.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_name Net-NATS-Streaming-Client
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Perl interface to NATS Streaming
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SK/SKOLYCHEV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
#
  # Basic Usage
  #
  This class is a subclass of Net::NATS::Client and delegates all networking
  to the parent.

  $client = Net::NATS::Streaming::Client->new(uri => 'nats://localhost:4222', clientID => 'test_client', clusterID => 'test-cluster');
  $client->connect() or die $!;

  # Simple Async Subscriber
  $subscription = $client->subscribe_channel({ subject => 'foo' }, sub {
      my ($message) = @_;
      printf("Received a message: %%s\n", $message->data);
  });
  $self->run;

  # Simple Publisher
  $client->publish_channel({ subject => 'foo', data => 'Hello, World!'});

  # Unsubscribe
  $client->unsubscribe_channel($subscription);

  # Close stream
  $client->close_stream();

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/N*

%changelog
