Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Net/Netmask.pm) perl-podlators
# END SourceDeps(oneline)
BuildRequires: perl-Net-Netmask
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Net-NBName
Version:        0.26
Release:        alt2_50
Summary:        NetBIOS Name Service Requests
License:        GPL+ or Artistic

URL:            https://metacpan.org/release/Net-NBName
Source0:        https://cpan.metacpan.org/authors/id/J/JM/JMACFARLA/Net-NBName-%{version}.tar.gz

BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  sed
# Run-time:
# Net::Netmask not used at tests
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
BuildRequires:  perl(diagnostics.pm)
BuildRequires:  perl(Test.pm)
Source44: import.info

%description
Net::NBName is a class that allows you to perform simple NetBIOS Name
Service Requests in your Perl code. It performs these NetBIOS operations
over TCP/IP using Perl's built-in socket support.

%prep
%setup -q -n Net-NBName-%{version}
for F in bin/* Changes README; do
    sed -i 's/\r//' "$F"
done
for F in bin/*; do
    /usr/bin/perl -pi -e 'print "#!/usr/bin/perl\n\n" if $. == 1' "$F"
done

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
%{make_build} test

%files
%doc Changes README
%{_bindir}/namequery.pl
%{_bindir}/nodescan.pl
%{_bindir}/nodestat.pl
%{perl_vendor_privlib}/Net

%changelog
