# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
BuildRequires: libnsl2-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name	 Net-NIS
%define upstream_version 0.44

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt6_23

Summary:    NIS interface to Perl 5	
License:    GPL
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Net/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl-devel
BuildRequires: pkgconfig(libnsl)
BuildRequires: pkgconfig(libtirpc)
Source44: import.info

%description
This is a snapshot release of the NIS interface to Perl 5.  There are
three parts to the interface: the raw component (Net::NIS), the object-
oriented component (Net::NIS::Table), and the tied interface (Net::NIS).

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor 
%make_build OPTIMIZE="%{optflags} -I/usr/include/nsl -I/usr/include/tirpc"
# (sb) known to fail:
#  http://nntp.x.perl.org/group/perl.cpan.testers/58036 (and more)
#make test

%install
%makeinstall_std 

%files
%doc Changes META.json META.yml  NIS README
%{perl_vendor_archlib}/Net
%{perl_vendor_archlib}/auto/Net


%changelog
