# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl(CGI/Carp.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Net-OpenID-Server
%define upstream_version 1.09

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_11

Summary:    Library for building your own OpenID server
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Net/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Digest/SHA.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(MIME/Base64.pm)
BuildRequires: perl(Net/OpenID/Common.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(URI.pm)
BuildArch:  noarch
Source44: import.info

%description
This is the Perl API for (the server half of) OpenID, a distributed
identity system based on proving you own a URL, which is then your
identity. More information is available at:

  http://openid.net/

As of version 1.01 this module has support for both OpenID 1.1 and 2.0.
Prior to this, only 1.1 was supported.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml README examples
%perl_vendor_privlib/*

%changelog
