Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Net-Ping-External
Version:        0.15
Release:        alt2_30
Summary:        Cross-platform interface to ICMP "ping" utilities
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Net-Ping-External
Source0:        https://cpan.metacpan.org/modules/by-module/Net/Net-Ping-External-%{version}.tar.gz
# https://github.com/chorny/Net-Ping-External/issues/6
# Patch based on http://matthias.sdfeu.org/devel/net-ping-external-cmd-injection.patch
Patch0:         perl-Net-Ping-External-CVE-2008-7319.patch
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
Source44: import.info

%description
Net::Ping::External is a module which interfaces with the "ping" command on
many systems. It presently provides a single function, ping(), that takes
in a hostname and (optionally) a timeout and returns true if the host is
alive, and false otherwise. Unless you have the ability (and willingness)
to run your scripts as the superuser on your system, this module will
probably provide more accurate results than Net::Ping will.

%prep
%setup -q -n Net-Ping-External-%{version}
%patch0 -p1 -b .CVE-2008-7319

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} $RPM_BUILD_ROOT/*

for i in Changes README ToDo; do
    sed -i 's/\r//' "$i"
done

%check
%{?_with_network_tests: make test }

%files
%doc Changes README ToDo
%{perl_vendor_privlib}/*

%changelog
