%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: java-devel-default perl(Data/UUID.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(IO/Dir.pm) perl(Inline/Java.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 2.030102
%define module_name Net-RabbitMQ-Java
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.030102
Release: alt1
Summary: Perl bindings for the RabbitMQ Java AMQP client library
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AA/AAR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Net::RabbitMQ::Java->init;
    
    # connect
    my $factory = Net::RabbitMQ::Java::Client::ConnectionFactory->new;
    $factory->setUsername('guest');
    $factory->setPassword('guest');
    $factory->setHost("localhost");
    my $conn = $factory->newConnection;
    my $channel = $conn->createChannel;
    
    # declare exchange and queues
    $channel->exchangeDeclare('my-exchange', "direct", 1);
    my $queue_name = $channel->queueDeclare->getQueue;
    $channel->queueBind($queue_name, 'my-exchange', 'my.routing.key');
    
    # publish
    $channel->basicPublish('my-exchange', 'my.routing.key', {}, 'Message contents');
    
    # manage transactions
    $channel->txSelect;
    $channel->txRollback;
    $channel->txCommit;
    
    # consume
    my $consumer = Net::RabbitMQ::Java::Client::QueueingConsumer->new($channel);
    $channel->basicConsume($queue_name, 0, $consumer);
    while (1) {
        my $delivery = $consumer->nextDelivery;
        print $delivery->getBody, "\n";
        $channel->basicAck($delivery->getEnvelope->getDeliveryTag, 0);
    }
    
    # set and poll callbacks
    $conn->addShutdownListener(sub {
        my $e = shift;
        print $e->getReason->getMethod->getReplyText, "\n";
    });
    $channel->setReturnListener(sub {
        my ($replyCode, $replyText, $exchange, $routingKey, $properties, $body) = @_;
        print "Unroutable message: $body\n";
    });
    ...
    Net::RabbitMQ::Java->processCallbacks;
    
    # disconnect    
    $channel->close;
    $conn->close;
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE-GPL2 LICENSE LICENSE-APACHE2 README LICENSE-MPL-RabbitMQ Changelog
%perl_vendor_privlib/N*
%perl_vendor_privlib/auto/*

%changelog
