%define module_name Net-SNTP-Client
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/INET.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.23
Release: alt1
Summary: Perl module to calculate the roundtrip delay d and
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GA/GARYFALOS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module exports a single method (getSNTPTime) and returns
 an associative hash of hashes upon RFC4330 and a string in
 case of an error occurs. The response from the NTP or SNTP server
 is beeen decoded to a human readable format. The obtained
 information recieved from the server can be can be used into
 further processing or manipulation according to the user needs.
 Maximum accuracy down to nano seconds can only be achieved on LinuxOS.


=over 4

=item * HOSTNAME

    -hostname: The mandatory key inorder the method to produce
    an output is only the hostname, the rest of the keys are optional.


=item * PORT

    -port: By default the the port is set to 123 (NTP default port).
    The user has the option to overwite the port based on the expected
    NTP port on the server side (e.g. -port => 123456).


=item * TIMEOUT

    -timeOut: By default the time out is set to 10 seconds. The user
    has the option to overwite the time out input option based on the
    expected connection time (e.g. timeOut => 15).


=item * RFC4330 OUTPUT

    -RFC4330: This is an optional way to produce an easy visual
    output based on RFC4330 documentation. Expected input is a string,
    integer or boolean in the form (0 or 1).


=item * CLEARSCREEN

    -clearScreen: This is an optional choice based on user preference
    if he/she desires to clear the "terminal screen" before printing
    the captured data. Expected input is a string, integer or boolean
    in the form (0 or 1).


=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ignore.txt README Changes
%perl_vendor_privlib/N*

%changelog
