%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(IO/Handle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Net/SSLeay.pm) perl(Socket.pm) perl(Sub/Exporter.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Net-SSLeay-OO
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: OO Calling Method for Net::SSLeay
Group: Development/Perl
License: artistic
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SAMV/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This set of modules adds an OO calling convention to the
the Net::SSLeay manpage module.  It steers away from overly abstracting things,
or adding new behaviour, instead just making the existing
functionality easier to use.

What does this approach win you over the Net::SSLeay manpage?

=over

=item Object Orientation

For a start, you get a blessed object rather than an integer to work
with, so you know what you are dealing with.  All of the functions
which were callable with `Net::SSLeay::foo($ssl, @args)' will then be
callable as plain `$ssl->foo(@args)'.

=item Namespaces

The OpenSSL functions use a C-style namespace convention, where
functions are prefixed by the type of the object that they operate on.
OpenSSL has several types of objects, such as a "Context" (this is a
bit like a bunch of pre-defined connection settings), and various
classes relating to X509, sessions, etc.

This module splits up the functions which the Net::SSLeay manpage binds into
Perl based on the naming convention, then sets up wrappers for them so
that you can just call methods on objects.

=item Exceptions

If an error is raised by the OpenSSL library, an exception is
immediately raised (trappable via `eval') which pretty-prints into
something presented a little less cryptic than OpenSSL's
`:'-delimited error string format.

=item fewer segfaults

This is currently more of a promise than a reality; but eventually
each of the access methods for the various objects will be able to
know their lifetime in a robust fashion, so you should get less
segfaults.  Eg, some SSL functions don't return object references
which are guaranteed to last very long, so if you wait too long before
getting properties from them you will get a segfault.

=back

On the flip side, what does this approach win you over other simpler
APIs such as the IO::Socket::SSL manpage?  Well, I guess it comes down to "Make
things as simple as possible, but no simpler".

Most SSL socket libraries tend to try to hide complexity from you, but
there really are things that you should consider; such as, shouldn't
you be validating the other end of your SSL connection has a valid
certificate?  Which SSL versions do you wish to allow?

the IO::Socket::SSL manpage lets you specify a lot of this stuff, but it's not
a very earnest implementation; it's just treated as a few extra
options passed to the constructor, a bit of magic at socket setup
time, and then hope that this will be enough.  The support for
verifying client certificates didn't even work when I tested it.

On the other hand, using the OpenSSL API fully means you are taken
through the stages of setup piece by piece.  You can easily do things
like check that your SSL configuration (eg server certificate) is
valid *before* you start daemonize or start accepting real sockets.

I'll try to keep the documentation as complete as possible - there's
nothing more annoying than thin wrapper libraries which don't help
much people trying to use them.  But in general, most functions
available in the OpenSSL manual will be available.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README COPYING.txt Changes.pod examples
%perl_vendor_privlib/N*

%changelog
