%define module_name Net-Statsd-Lite
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Devel/StrictMode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Select.pm) perl(IO/Socket.pm) perl(Module/Load.pm) perl(Module/Metadata.pm) perl(Moo.pm) perl(MooX/TypeTiny.pm) perl(Net/EmptyPort.pm) perl(Pod/Coverage/TrustPod.pm) perl(Ref/Util.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Sub/Quote.pm) perl(Sub/Util.pm) perl(Test/CleanNamespaces.pm) perl(Test/Deep.pm) perl(Test/DistManifest.pm) perl(Test/EOL.pm) perl(Test/Fixme.pm) perl(Test/Kwalitee.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test/Roo.pm) perl(Test/Roo/DataDriven.pm) perl(Test/Roo/Role.pm) perl(Test/TCP.pm) perl(Types/Common.pm) perl(curry.pm) perl(experimental.pm)
BuildRequires: perl(if.pm) perl(lib.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.8.0
Release: alt1
Summary: A lightweight StatsD client that supports multimetric packets
Group: Development/Perl
License: artistic_2
URL: https://metacpan.org/release/Net-Statsd-Lite

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RR/RRWO/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is a small StatsD client that supports the
StatsD Metrics Export Specification v0.1.

It supports the following features:

=over

=item Multiple metrics can be sent in a single UDP packet.

=item It supports the meter and histogram metric types.

=back

Note that the specification requires the measured values to be
integers no larger than 64-bits, but ideally 53-bits.

The current implementation expects values to be integers, except where
specified. But it otherwise does not enforce maximum/minimum values.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/N*

%changelog
