%set_perl_req_method relaxed
Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(BSD/Resource.pm) perl(HTML/FormatText.pm) perl(HTML/PrettyPrinter.pm) perl(HTML/TreeBuilder.pm) perl(Text/Format.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Net-eBay
Version:        0.62
Release:        alt1_5
Summary:        Perl Interface to XML based eBay API
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Net-eBay
Source0:        https://cpan.metacpan.org/authors/id/I/IC/ICHUDOV/Net-eBay-%{version}.tar.gz
# Do no load a private IgorBusinessRules module, CPAN RT#105379
Patch0:         Net-eBay-0.61-Do-use-non-existent-IgorBusinessRules.patch

BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed
# Run-time:
# BSD::Resource not used at tests
BuildRequires:  perl(Carp.pm)
# Cwd not used at tests
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(DateTime/Precise.pm)
# Getopt::Long not used at tests
# HTML::FormatText not used at tests
# HTML::PrettyPrinter not used at tests
# HTML::TreeBuilder not used at tests
BuildRequires:  perl(HTTP/Date.pm)
BuildRequires:  perl(HTTP/Request/Common.pm)
BuildRequires:  perl(HTTP/Status.pm)
# LWP::Protocol::https for HTTPS, not Crypt::SSLeay or Net::SSLeay,
# CPAN RT#105378
BuildRequires:  perl(LWP/Protocol/https.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
# Text::Format not used at tests
BuildRequires:  perl(utf8.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(XML/Dumper.pm)
BuildRequires:  perl(XML/Simple.pm)
# Tests:
BuildRequires:  perl(Test/More.pm)
# Optional tests:
BuildRequires:  perl(Test/Pod.pm)
# Test::Pod::Coverage 1.04 disabled, CPAN RT#97511
# LWP::Protocol::https for HTTPS, not Crypt::SSLeay or Net::SSLeay,
# CPAN RT#105378
Requires:       perl(LWP/Protocol/https.pm)
Source44: import.info


%description
This module helps user to easily execute queries against eBay's XML API.


%prep
%setup -q -n Net-eBay-%{version}
%patch0 -p1
# Skip Test::Pod::Coverage tests because they are not useful and fail,
# CPAN RT#97511
rm t/pod-coverage.t
perl -i -ne 'print $_ unless m{^t\/pod-coverage.t$}' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} $RPM_BUILD_ROOT

%check
make test

%files
%doc Changes README
%{_bindir}/ebay-add-item.pl
%{_bindir}/ebay-get-categories.pl
%{_bindir}/ebay-get-item.pl
%{_bindir}/ebay-official-time.pl
%{_bindir}/ebay-revise-item.pl
%{_bindir}/ebay-search.pl
%{_bindir}/ebay-validate-test-user.pl
%{perl_vendor_privlib}/*

%changelog
