%define module_name NetHack-NAOdash
BuildRequires: perl-podlators
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/SHA.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Spec/Functions.pm) perl(HTML/TreeBuilder.pm) perl(HTTP/Tiny.pm) perl(JSON/MaybeXS.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Plack/Component.pm) perl(Term/ANSIColor.pm) perl(Test/Perl/Critic.pm) perl(Text/XLogfile.pm) perl(parent.pm) perl(re.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Analyze NetHack xlogfiles and extract statistics
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
NetHack::NAOdash analyzes a NetHack xlogfile and reports statistics.
There are two types of statistics: checks, which are flags
(booleans) and numbers which are integers.

The checks are tracked across all games. That is, a check will
be true in the statistics if it is true in at least one game. Except
for checks in the *Achievements* category, only games that end in
an ascension are considered for awarding a check.

The checks, sorted by category, are:

=over

=item Achievements

These start with `achieve_' and represent significant milestones in a
game. They are usually relevant only for users who never ascended, as
a game that ends in an ascension generally meets all of them.

  achieve_sokoban  achieve_luckstone   achieve_medusa achieve_bell
  achieve_gehennom achieve_candelabrum achieve_book   achieve_invocation
  achieve_amulet   achieve_endgame     achieve_astral achieve_ascended

=item Starting Combos

These look like `combo_role_race_alignment' and represent
role/race/alignment combinations in ascended games. The starting
alignment, not the alignment at the end of the game is considered. For
example, `cav_gno_neu' is true if the user ascended at least one
gnomish caveman.

=item Conducts

These start with `conduct_' and represent the 12 officially tracked
conducts.

  conduct_foodless     conduct_vegan        conduct_vegetarian
  conduct_atheist      conduct_weaponless   conduct_pacifist
  conduct_illiterate   conduct_genocideless conduct_polypileless
  conduct_polyselfless conduct_wishless     conduct_artiwishless

=item Unofficial Conducts

These start with `uconduct_' and represent conducts that are not
officially tracked by the game.

  uconduct_survivor uconduct_bones uconduct_minscore

=back

The numbers are:

=over

=item totalrealtime

The total time spent playing NetHack on NAO, in seconds.

=item games

The number of games played.

=item ascensions

The number of games played that ended in an ascension.

=item maxhp

The highest maxHP at the end of an ascension.

=item maxpoints

The highest score obtained at the end of an ascension.

=item maxconducts

The maximum number of conducts at the end of an ascension.

=item minturns

The minimum turns across ascended games.

=item minrealtime

The minimum realtime across ascended games, in seconds.

=back

This module exports two functions:

=over

=item naodash_xlog(*@lines*)

=item naodash_xlog(*$xlog*)

Takes the contents of an xlogfile and returns the results of the
analysis. The arguments are joined together then split by the newline
character, so they can be specified as a single string, as a list of
lines, or as a combination thereof.

The return value is of the following form:

  { checks => ['achieve_sokoban', 'achieve_luckstone', ...],
    numbers => {totalrealtime => 12345, games => 2, ...} }

In other words, `@{$result->{checks}}' is an array of checks
that are true and `%%{$result->{numbers}}' is a hash of
numbers.

=item naodash_user(*$nao_username*)

Retrieves the xlogfile of a user from NAO and gives it to
naodash_xlog. Dies if no xlogfile is found or if the server cannot
be contacted.

This method caches the downloaded xlogfiles for one day in the
directory named by the NAODASH_CACHE environment variable.

=back

%package scripts
Summary: %name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*
%perl_vendor_privlib/N*

%files scripts
%_bindir/*
%_man1dir/*
%_man1dir/*


%changelog
