# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(IO/Socket/INET.pm) perl(IPC/Open3.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Test/Spec.pm) perl(Time/HiRes.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.001
%define module_name Nginx-Runner
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: run nginx proxy server
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/U/UN/UNDEF/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use Nginx::Runner;

    my $nginx = Nginx::Runner->new;

    $nginx->proxy("127.0.0.1:8080" => "127.0.0.1:3000");
    
    $nginx->proxy(
        "https://127.0.0.1:8443" => "127.0.0.1:3000",
        [ssl_certificate     => "/etc/ssl/nginx/nginx.pem"],
        [ssl_certificate_key => "/etc/ssl/nginx/nginx.pem"]
    );
    
    $nginx->run;

    $SIG{INT} = sub { $nginx->stop };

    print "Server available at ",
      "http://127.0.0.1:8080 and https://127.0.0.1:8443\n";

    sleep;


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/N*

%changelog
