# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI/Carp.pm) perl(CGI/Simple.pm) perl(Capture/Tiny.pm) perl(Config.pm) perl(Crypt/RC4.pm) perl(DBI.pm) perl(Data/Dumper.pm) perl(DateTime.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find/Rule.pm) perl(File/Slurp.pm) perl(HTTP/AcceptLanguage.pm) perl(HTTP/Tiny.pm) perl(Hash/AsObject.pm) perl(IO/Compress/Gzip.pm) perl(IO/Handle.pm) perl(Import/Into.pm) perl(Log/Tiny.pm) perl(MIME/Base64.pm) perl(Module/Load.pm) perl(Module/Runtime.pm) perl(Moose.pm) perl(MooseX/Declare.pm) perl(MooseX/MethodAttributes.pm) perl(MooseX/NonMoose.pm) perl(Router/Generic.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Tie/IxHash.pm) perl(Time/HiRes.pm) perl(Time/Local.pm) perl(URI.pm) perl(URI/Escape.pm)
BuildRequires: perl(XML/TreePP.pm) perl(base.pm) perl(feature.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_version 0.18
%define module_name Nile
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.18
Release: alt1
Summary: Visual Web App Framework Separating Code From Design Multi Lingual And Multi Theme.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/ME/MEWSOFT/mewsoft/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Nile - Visual Web App Framework Separating Code From Design Multi Lingual And Multi Theme.

Alpha version, do not use it for production. The project's homepage https://github.com/mewsoft/Nile.

The main idea in this framework is to separate all the html design and layout from programming. 
The framework uses html templates for the design with special xml tags for inserting the dynamic output into the templates.
All the application text is separated in langauge files in xml format supporting multi lingual applications with easy traslating and modifying all the text.

_#!/usr/bin/perl
_use Nile;
_my $app = Nile->new;

_$app->init(
__#base application path, auto detected if not set
__#path__=>_dirname(File::Spec->rel2abs(__FILE__)),
__#site language for user, auto detected if not set
__#lang__=>_"en-US"
__#theme used
__#theme__=>_"default"
__);
_
_#handle request and send response
_#$app->run;
_
_# control everything manually
_my $request = $app->request;

_# load  global shared application configuration file
_$app->config->load($app->file->catfile($app->var->get("config_dir"), "config"));
_say $app->config->get("database/user");
_
_# connect to the database. pass the connection params or try to load it from the config object.
_#$app->connect();
_#$app->connect(%%params);
_
_# set or get some global shared application variables
_#my $var = $app->var;
_#$var->Body("Body variable"); # use auto getter and setter methods
_#say "Title: ". $var->set("Title", "Hello world Title")->get("Title");
_
_# load langauge file general.xml
_$app->lang->load("general");
_
_# load routes file route.xml
_$self->router->load("route");
_
_# run the application and show the content.
_$self->dispatcher->dispatch;

_# you can run any plugin or route
_#$self->dispatcher->dispatch('/accounts/register/create');
_#$self->dispatcher->dispatch('/accounts/register/create', 'POST');
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/N*

%changelog
