# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Number-Natural-SetTheory
%define upstream_version 0.004

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Set-theoretic definition of natural numbers
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Number/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(boolean.pm)
BuildArch:  noarch
Source44: import.info

%description
For years mathematicians struggled to answer what numbers exactly *are*. A
satisfactory answer came out of the world of set theory. Because Perl
doesn't have sets as a first class data type, we use arrays instead. 

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CONTRIBUTING COPYRIGHT CREDITS Changes INSTALL LICENSE META.json META.yml  README SIGNATURE
%perl_vendor_privlib/*

%changelog
