# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/Util.pm) perl(Pod/Coverage/TrustPod.pm) perl(String/Pad.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/Bundle/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Number-Pad
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Pad numbers so the decimal point (or "E" if in exponential notation) align
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Number-Pad

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Number::Pad qw(pad_numbers);

 my $res = pad_numbers(
       ["1",
        "-20",
        "3.1",
        "-400.56",
        "5e1",
        "6.78e02",
        "-7.8e-10",
        "Inf",
        "NaN"],         # 1st arg: (required) the numbers
       20,              # 2nd arg: (optional) number of characters; if unspecified will just pad so all numbers fit
       'right',         # 3rd arg: (optional) alignment: l/left/r/right/c/center. default is l
       undef,           # 4th arg: (optional) pad character, default is space
       0,               # 5th arg: (optional) whether we should truncate if the length of widest number exceeds specified number of characters. default is false.
 );

Result:

 [ #12345678901234567890
   "             1      ",
   "           -20      ",
   "             3.1    ",
   "          -400.56   ",
   "             5e1    ",
   "             6.78e02",
   "            -7.8e-10",
   "           Inf      ",
   "           NaN      ",
 ]

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/N*

%changelog
