# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Scalar/Util.pm) perl(base.pm) perl(overload.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Number-RGB
%define upstream_version 1.41

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Manipulate RGB Tuples
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Number/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Attribute/Handlers.pm)
BuildRequires: perl(Class/Accessor/Fast.pm)
BuildRequires: perl(Params/Validate.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/More.pm)

BuildArch: noarch
Source44: import.info


%description
This module creates RGB tuple objects and overloads their operators to make
RGB math easier. An attribute is also exported to the caller to make
construction shorter.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%install
%makeinstall_std

%files
%doc Changes README META.yml
%{perl_vendor_privlib}/*


%changelog
