# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name OCR-OcrSpace
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Perl Interface to access L<https://ocr.space/OCRAPI>
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SP/SPAJAI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
#using object oriented interaface
    use OCR::OcrSpace;

    my $ocrspace_obj = OCR::OcrSpace->new();

    my $param = {
        file                         => '/tmp/image.png',                     #full iamge path

                                    or 

        url                         => 'http://imagedatabase.com/test.jpg'   #image url to fetch from

                                    or

        base64Image                 => 'data:image/png;base64,iVBORw0KGgoAx7/7LNuCQS0posnocgEAFpySUVORK5CYII='

        #following optional parameter
        ocr_space_url                  => "https://api.ocr.space/parse/image",  
        apikey                         => 'XXXXXXXXXXXXXXXXXX',                 #API Key (mandatory)
        isOverlayRequired              =>'True',                                #optional
        language                       =>'eng' ,                                #optional
        scale                          => 'True',                               #optional
        isTable                        => 'True',                               #optional
        OCREngine                      => 2,                                    #optional
        filetype                       => 'PNG',                                #optional
        detectOrientation              => 'False',                              #optional
        isCreateSearchablePdf          => 'True',                               #optional
        isSearchablePdfHideTextLayer   => 'True',                               #optional

    };

    print $ocrspace_obj->get_result( $param );


    #using non-object oriented interaface

    use OCR::OcrSpace;
    print get_result( $param );



    #since ocrSpace uses http as well as HTTPs you can always set the following varible before call
    $BASE_URL

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE ignore.txt
%perl_vendor_privlib/O*

%changelog
