%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(MooseX/Meta/Attribute/Index.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.30
%define module_name ODG-Record
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.30
Release: alt1
Summary: Perl extension for efficient and simple manipulation of row-based records. 
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CT/CTBROWN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
THIS VERSION BREAKS BACKWARD WITH PREVIOUS VERSIONS.  THE API IS SIMPLIER.

ODG::Record is an extensible the Moose manpage-based class for efficiently and 
simply working with row based records.  ArrayRefs are much faster than 
HashRefs especially for long arrays. This module circumvents the Mooses' 
HashRef based objects and places designated attributes in the _data slot, 
an ArrayRef.  This allows for construction of more efficient row-based
processing but retains the Moose flavor.

To work with a new record, simply change the reference of the _data slot.

_$record->_data( [ 'Some', 'Array', 'Ref' ] );

Since the emphasis is on speed and generally connection to tightly typed
systems such as Databases, we break the Moose encapsulation and install
our own type-checking free accessors.  Type checking is left up to the 
user.  Since we have eliminated the type-checking, we have also added 
another bit of magic, L-based accessors.  So rather than coding:

_$record->first_name( "Frank" );

You can use the much more natural appearing:

    $record->first_name = "Frank" 

This only works for attributes that are placed in the ArrayRef.   Other
attributes have normal Moose behavior.



%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes TODO.pod README
%perl_vendor_privlib/O*

%changelog
