%define module_name OSPF-LSDB
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/dot perl(CGI.pm) perl(Data/Validate.pm) perl(Data/Validate/Struct.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(IPC/Open2.pm) perl(List/MoreUtils.pm) perl(POSIX.pm) perl(Pod/Checker.pm) perl(Regexp/Common.pm) perl(Regexp/IPv6.pm) perl(Sys/Hostname.pm) perl(Test/EOL.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(Test/Pod.pm) perl(Test/Requires.pm) perl(Test/Strict.pm) perl(Time/HiRes.pm) perl(YAML/Syck.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.18
Release: alt1
Summary: class containing OSPF link state database
Group: Development/Perl
License: bsd
URL: https://sourceforge.net/projects/ospfview/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLUHM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The OSPF::LSDB module serves as base class for all the other
OSPF::LSDB::... modules.
It contains the link state database, can do versioning and validation.
To parse, load, store or display the LSDB, convert it into instances
of more specific classes.
The new() method implements a copy constructor to share LSDB
references with minimal overhead.

Most names of the database fields are named after RFC 2328 - OSPF
version 2.
Keys of RFC 5340 - OSPF for IPv6 with a comparable semantics in
version 2, have kept their old names to allow code reuse.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE THANKS TODO doc example
%perl_vendor_privlib/O*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
