%define module_name Object-Destroyer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.02
Release: alt1
Summary: Make objects with circular references DESTROY normally
Group: Development/Perl
License: perl
URL: https://github.com/simbabque/Object-Destroyer

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SI/SIMBABQUE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
One of the biggest problem with working with large, nested object trees is
implementing a way for a child node to see its parent. The easiest way to
do this is to add a reference to the child back to its parent.

This results in a "circular" reference, where A refers to B refers to A.
Unfortunately, the garbage collector perl uses during runtime is not capable
of knowing whether or not something ELSE is referring to these circular
references.

In practical terms, this means that object trees in lexically scoped 
variable ( e.g. `my $Object = Tree->new' ) will not be cleaned up when
they fall out of scope, like normal variables. This results in a memory leak
for the life of the process, which is a bad thing when using mod_perl or 
other processes that live for a long time.

Object::Destroyer allows for the creation of "Destroy" handles. The handle is
"attached" to the circular relationship, but is not a part of it. When the
destroy handle falls out of scope, it will be cleaned up correctly, and while
being cleaned up, it will also force the data structure it is attached to to be 
destroyed as well. 
Object::Destroyer can call a specified release method on an object 
(or method DESTROY by default). 
Alternatively, it can execute an arbitrary user code passed to constructor as a code reference.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes
%perl_vendor_privlib/O*

%changelog
