Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
%add_findreq_skiplist %perl_vendor_privlib/Object/InsideOut/[a-z]*.pm
%add_findreq_skiplist %perl_vendor_privlib/Object/InsideOut/Secure.pm
%add_findreq_skiplist %perl_vendor_privlib/Object/InsideOut/Cumulative.pm
%add_findreq_skiplist %perl_vendor_privlib/Object/InsideOut/Chained.pm
%add_findreq_skiplist %perl_vendor_privlib/Object/InsideOut/Overload.pm
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Object-InsideOut
Version:        4.05
Release:        alt3_23
Summary:        Comprehensive inside-out object support module
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Object-InsideOut
Source0:        https://cpan.metacpan.org/modules/by-module/Object/Object-InsideOut-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(attributes.pm)
BuildRequires:  perl(B.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Exception/Class.pm)
BuildRequires:  perl(Scalar/Util.pm)
# Optional run-time
%if %{undefined perl_bootstrap}
BuildRequires:  perl(Math/Random/MT/Auto.pm)
%endif
BuildRequires:  perl(Want.pm)
# Test only
BuildRequires:  perl(base.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(threads.pm)
BuildRequires:  perl(Thread/Queue.pm)
BuildRequires:  perl(threads/shared.pm)
# Optional tests
BuildRequires:  perl(Storable.pm)
# Dependencies
Requires:       perl(Data/Dumper.pm) >= 2.131
Requires:       perl(Scalar/Util.pm) >= 1.230

# Remove underspecified dependencies



%if %{defined perl_bootstrap}

%endif
Source44: import.info
%filter_from_requires /^perl(Scalar.Util.pm)/d
%filter_from_requires /perl(Math.Random.MT.Auto.pm)/d

%description
This module provides comprehensive support for implementing classes using the
inside-out object model.

This module implements inside-out objects as anonymous scalar references that
are blessed into a class with the scalar containing the ID for the object
(usually a sequence number). Object data (i.e., fields) are stored within the
class's package in either arrays indexed by the object's ID, or hashes keyed
to the object's ID.

%prep
%setup -q -n Object-InsideOut-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
make test

%files
%doc examples/ Changes README
%{perl_vendor_privlib}/Bundle/
%{perl_vendor_privlib}/Object/

%changelog
