# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Moo.pm) perl(Test/More.pm) perl(Unicode/Normalize.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name Object-String
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: A string object for Perl 5
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Object-String

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BE/BERZINV/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
A string object for Perl 5.

`Object::String' have a lot of "modern" features and supports method chaining. A helper is also provided to 
help to build a string object.

`Object::String' is heavily inspired by stringjs a Ruby string object.

    # Normal way to build a string object
    my $string = Object::String->new(string => 'test');

    # With the helper
    my $string = str('test');

    # Display the string
    say $string->string;

    # Method chaining 
    say $string->chomp_right->to_upper->string;
    say str('testZ')->chop_right->to_upper->string; # TEST
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changelog LICENSE README.md README
%perl_vendor_privlib/O*

%changelog
