Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(HTTP/Daemon.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-OpenFrame
Version:        3.05
Release:        alt2_52
Summary:        Framework for network enabled applications
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/OpenFrame
Source0:        https://cpan.metacpan.org/authors/id/R/RC/RCLAMP/OpenFrame-%{version}.tar.gz
Source1:        README.LICENSE
# rhbz#716174, submitted to upstream RT#69077
Patch0:         %{name}-3.05-Adapt-CGI-Cookie-construction-to-CGI-3.51.patch
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(CGI.pm)
BuildRequires:  perl(CGI/Cookie.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(File/Type.pm)
BuildRequires:  perl(FileHandle.pm)
BuildRequires:  perl(HTTP/Headers.pm)
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(HTTP/Status.pm)
BuildRequires:  perl(IO/Null.pm)
BuildRequires:  perl(Pipeline.pm)
BuildRequires:  perl(Pipeline/Production.pm)
BuildRequires:  perl(Pipeline/Segment.pm)
BuildRequires:  perl(warnings/register.pm)
# Tests only
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Find/Rule.pm)
BuildRequires:  perl(HTTP/Request.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Pipeline/Segment/Tester.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Simple.pm)
BuildRequires:  perl(URI.pm)
BuildRequires:  perl(vars.pm)
Requires:       perl(CGI/Cookie.pm) >= 0.010
Requires:       perl(File/Temp.pm) >= 0.010
Requires:       perl(File/Type.pm) >= 0.010
Requires:       perl(IO/Null.pm) >= 0.010
Requires:       perl(Pipeline.pm) >= 2.0






Source44: import.info
%filter_from_requires /^perl(CGI.Cookie.pm)/d
%filter_from_requires /^perl(File.Temp.pm)/d
%filter_from_requires /^perl(File.Type.pm)/d
%filter_from_requires /^perl(IO.Null.pm)/d
%filter_from_requires /^perl(Pipeline.pm)/d

%description
OpenFrame is a framework for network services serving to multiple media
channels - for instance, the web, WAP, and digital television. It is built
around the Pipeline API, and provides extra abstraction to make delivery of
a single application to multiple channels easier.

%prep
%setup -q -n OpenFrame-%{version}
%patch0 -p1 -b .cgi3.51
cp -p %{SOURCE1} .

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
rm -f %{buildroot}%{perl_vendor_privlib}/saofs.pl

%check
make test

%files
%doc CHANGES README saofs.pl README.LICENSE
%{perl_vendor_privlib}/*

%changelog
