%define module_name OpenGL-GLFW
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(ExtUtils/MakeMaker.pm) perl(OpenGL/Modern.pm) pkgconfig(glfw3)
# END SourceDeps(oneline)
%define _without_test 1
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0401
Release: alt1
Summary: Perl bindings for the GLFW library
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETJ/%{module_name}-%{version}.tar.gz

%description
the OpenGL::GLFW manpage provides perl5 bindings to the GLFW
library for OpenGL applications development.  The
implementation is a direct translation of the
GLFW C interface to perl.  You can use the official
GLFW documentation at http://www.glfw.org/documentation.html
for the specifics of the GLFW API.  The documentation
here is on the perl usages and calling conventions.

At the top level, we have the following correspondences
between these perl bindings and the C API:

=over 4

=item *

`GLFWwindow', `GLFWmonitor', and `GLFWcursor' are
opaque data types and pointers to them are returned as
perl scalar references.

=item *

`GLFWvidmode', `GLFWgammaramp', and `GLFWimage' types
are mapped to perl hashes and passed and returned as the
corresponding references.

The pointers to red, green, and blue channels of the
gamma ramp become strings of packed ushort values.

Similarly, the pointer to pixels in the images use
a packed string of `4 x width x height' unsigned
char values per pixel as `[R,G,B,A]' for pixels `(0,0)'
through `(width-1,height-1)'.

See the `examples/checkimg.pl' for an example using the
Perl Data Language module, the PDL manpage, to construct the the
`GLFWimage' hash.

=item *

The glfwSetXxxCallback routines do not implement the
return value for the previous callback.  If you need
it, you'll need to track and save yourself.

=item *

Vulkan is not currently supported and `glfwVulkanSupported'
always returns false.

=item *

Neither `glfwGetProcAddress' nor `glfwExtensionSupported'
are implemented.  Please use the the OpenGL::Modern manpage or the OpenGL manpage
modules instead.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md TODO.md examples
%perl_vendor_archlib/O*
%perl_vendor_autolib/*

%changelog
