%define module_name OpenTelemetry
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bytes/Random/Secure.pm) perl(Class/Inspector.pm) perl(Class/Method/Modifiers.pm) perl(DBD/Mem.pm) perl(DBI.pm) perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Feature/Compat/Defer.pm) perl(Feature/Compat/Try.pm) perl(File/Spec.pm) perl(Future.pm) perl(Future/AsyncAwait.pm) perl(HTTP/Headers.pm) perl(HTTP/Request/Common.pm) perl(HTTP/Response.pm) perl(HTTP/Tiny.pm) perl(LWP/UserAgent.pm) perl(List/Util.pm) perl(Log/Any.pm) perl(Metrics/Any.pm) perl(Module/Build/Tiny.pm) perl(Module/Load.pm) perl(Module/Pluggable.pm) perl(Mutex.pm) perl(Object/Pad.pm) perl(Ref/Util.pm) perl(Sentinel.pm) perl(Syntax/Keyword/Dynamically.pm) perl(Test/More.pm) perl(Test2/V0.pm) perl(URI.pm) perl(URL/Encode.pm) perl(UUID/URandom.pm) perl(X/Tiny.pm) perl(XS/Parse/Sublike.pm) perl(experimental.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.017
Release: alt1
Summary: supporting for application process monitoring, as defined by opentelemetry.io
Group: Development/Perl
License: perl
URL: https://github.com/team-at-cpan/OpenTelemetry

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJATRIA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
OpenTelemetry is due to become the successor to the OpenTracing initiative.
It includes additional functionality relating to metrics,
and at the time of writing is an evolving specification.

Current status of the official spec can be tracked here:

https://github.com/open-telemetry/opentelemetry-specification/blob/master/README.md

Note that the https://opentracing.io specification is currently more widely supported,
but eventually the OpenTracing::Any manpage and the OpenTelemetry::Any manpage
should be able to coaAxist in a codebase and support collectors
for either system.

For metrics, see the Metrics::Any manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/O*
%perl_vendor_privlib/T*

%changelog
