# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/HMAC_SHA1.pm) perl(Exception/Class.pm) perl(LWP.pm) perl(MIME/Base64.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(XML/XPath.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name OpenTok-API
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Perl SDK for OpenTok
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/ME/MEPHIST/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
1. Generate Token

    use OpenTok::API;
    
    # Get your own API-keys from http://www.tokbox.com/opentok
    my $ot = OpenTok::API->new(
        'api_key'    => $api_key, 
        'api_secret' => $api_secret,
        'mode'       => "development"|"production",
    );
    
2. Create new session

    my $session_id = $ot->create_session( 
        location => '', 
        'p2p.preference' => "enabled"|"disabled" 
    )->getSessionId();
    
3. Generate a new token for session
    
    my $token = $ot->generate_token(
        session_id => $session_id, 
        role => "publisher"|"subscriber"|"moderator" 
    );

4. Now insert your $api_key, $session_id, and $token into your template using your favourite templating engine

    # TT example 

    # In server side code
    my $tt = Template->new(...});
    my $vars = { api_key => $api_key, session_id => $session_id, token => $token };
    $tt->process($template, $vars) || die $tt->error(), "\n";

    # In HTML (javascript part)
    var apiKey    = "[%% api_key %%]";
    var sessionId = "[%% session_id %%]";
    var token     = "[%% token %%]";
    ...
    var session = TB.initSession(sessionId);
    session.addEventListener("sessionConnected", sessionConnectedHandler);
    session.addEventListener("streamCreated", streamCreatedHandler);
    session.connect(apiKey,token);



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/O*

%changelog
