%define module_name OpenTracing-Interface
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(Function/Parameters.pm) perl(Import/Into.pm) perl(Moo.pm) perl(Package/Constants.pm) perl(Role/Declare/Should.pm) perl(Role/Inspector.pm) perl(Role/Tiny/With.pm) perl(Syntax/Feature/Maybe.pm) perl(Test/Most.pm) perl(Test/OpenTracing/Interface.pm) perl(Type/Library.pm) perl(Type/Tiny.pm) perl(Type/Utils.pm) perl(Types/Common/Numeric.pm) perl(Types/Interface.pm) perl(Types/Standard.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.206.1
Release: alt1
Summary: API definition for OpenTransport implementations
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VA/VANHOESEL/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
'OpenTracing API for Perl' is Copyright (C) 2019, Perceptyx Inc, Theo van Hoesel

# OpenTracing API for Perl

This package describes the OpenTracing API for Perl

## Required Reading

In order to understand the Perl platform API, one must first be familiar with
[the OpenTracing project](http://opentracing.io/)
and
[terminology](http://opentracing.io/documentation/pages/spec)
more generally.

## Usage

### Singleton initialization

The simplest starting point is to set the global tracer. As early as possible,
do:

```perl
use OpenTracing;

OpenTracing->set_global_tracer( SomeTracerImplementation->new( ... ) );
```
## About

The interfaces being defined as roles
( using [Role::Tiny](https://metacpan.org/pod/Role::Tiny) )
and use `around` method modifiers, instead of `require`, we do want to wrap the
method in type checking
( using [Type::Tiny](https://metacpan.org/pod/Type::Tiny) and friends ).


## LICENSE INFORMATION

This library is free software; you can redistribute it and/or modify it under
the terms of the Artistic License 2.0.

This library is distributed in the hope that it will be useful, but it is
provided .e'as is.e' and without any express or implied warranties.

For details, see the full text of the license in the file LICENSE.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE.md CHANGES examples
%perl_vendor_privlib/O*

%changelog
