# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(CPAN.pm) perl(Catalyst.pm) perl(Catalyst/Action/REST.pm) perl(Catalyst/Controller.pm) perl(Catalyst/Controller/REST.pm) perl(Catalyst/Engine/HTTP.pm) perl(Catalyst/Helper.pm) perl(Catalyst/Model.pm) perl(Catalyst/Model/DBIC/Schema.pm) perl(Catalyst/Plugin/ConfigLoader.pm) perl(Catalyst/Plugin/Params/Nested.pm) perl(Catalyst/Plugin/Static/Simple.pm) perl(Catalyst/Runtime.pm) perl(Catalyst/Test.pm) perl(Catalyst/View.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/ResultClass/HashRefInflator.pm) perl(DBIx/Class/ResultSet.pm) perl(DBIx/Class/Schema.pm) perl(DBIx/Class/TimeStamp.pm) perl(DateTime.pm) perl(DateTime/Format/DBI.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Copy/Recursive.pm)
BuildRequires(pre): perl(File/Find.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(HTTP/Headers.pm) perl(HTTP/Request.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(JSON/XS.pm) perl(LWP/Simple.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Osgood/Client.pm) perl(Osgood/Event.pm) perl(Osgood/EventList.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Text.pm) perl(Pod/Usage.pm) perl(Socket.pm) perl(Test/More.pm) perl(URI.pm) perl(YAML.pm) perl(YAML/Dumper.pm) perl(YAML/Loader.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(lib.pm)
# END SourceDeps(oneline)
%define module_version 2.0.1
%define module_name Osgood-Server
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators perl(DateTime/Format/SQLite.pm)

Name: perl-%module_name
Version: 2.0.1
Release: alt1
Summary: Event Repository
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GP/GPHAT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Osgood is a passive, persistent, stateless event repository.

* Passive: Osgood doesn't seek out events, it only waits for notification of
them.

* Persistent: Events are durable, they do not disappear if the server goes
offline.

* Stateless: Events in Osgood are read-only.  You cannot change them.

What's all that fancy talk mean?  Osgood is a system wherein you record the
fact that something happened.  A client library (the Osgood::Client manpage that allows
you to send events to Osgood and to later retrieve them.

Effectively we are talking about an implementation of the Publisher /
Subscriber model.  This implementation is built using HTTP as the medium
and a relational database as the backing store.

An example may help to illustrate the usefulness.

Imagine a company that sells widgets.  Sometimes, customers are unhappy and
cancel the widgets.  When a customer calls to do so, the call center dutifully
cancels the order.  This works fine and the world is a happy place.

One day a new marketing employee decides to try and woo these customers back.
She asks you to build a system to send an email to a customer that cancels,
promising a $5 coupon to come back for more widgets!  This is a great idea,
and it is a great chance to use Osgood.

When the cancellation happens, you add a smidge of code that uses
Osgood::Client to send an event.  You might use descriptions like:

  my $event = Osgood::Event->new(
      object    => 'Order',
      action    => 'canceled',
      params    => {
          id    => 12345
      }
  );
  my $list = Osgood::EventList->new(events => [ $event ]);
  $client->send($list);

Meaning that Order #12345 was canceled.

Later, you whip up a job that runs every hour that queries Osgood for all
the orders that have been canceled.

  $client->query({
      object    => 'Order',
      action    => 'canceled',
  });

Now you have a list!  But every call returns ALL the Order canceled events that
happened, ever!  The query method provides a bunch of constraints to fix that.
The most useful of which is 'id'.  Providing query with an id limits the
returned events to all the events that have an ID GREATER THAN THE ONE
PROVIDED.

There are other constraints provided in the Osgood::Server::Controller::Event manpage
such as date_before and date_after.

The advantage of this implementation is that you can create subscribers
to an event without adding any new code to your cancellation process.  State
is maintained by the jobs that do the querying, however you choose to
implement it.  We use ids, you might use dates.

IMPORTANT: 

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc TODO README Changes
%perl_vendor_privlib/O*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
