%define module_version 0.06
%define module_name Ovirt
# BEGIN SourceDeps(oneline):
BuildRequires: perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Log/Log4perl.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Scalar/Util.pm) perl(URI/Escape.pm) perl(XML/Hash/XS.pm) perl(XML/LibXML.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Bindings for oVirt REST API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HE/HEINCE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use Ovirt::VM;
 use Ovirt::Template;
 use Ovirt::Cluster;
 use Ovirt::Host;
 use Ovirt::Display;

 my %%con = (
            username                => 'admin',
            password                => 'password',
            manager                 => 'ovirt-mgr.example.com',
            vm_output_attrs         => 'id,name,state,description', # optional
            cluster_output_attrs    => 'id,name,cpu_id,cpu_arch,description', # optional
 );

 my $vm         = Ovirt::VM         ->new(%%con);
 my $cluster    = Ovirt::Cluster    ->new(%%con);
 my $template   = Ovirt::Template   ->new(%%con);
 my $host       = Ovirt::Host       ->new(%%con);

 # return xml output
 print $vm      ->list_xml;   
 print $cluster ->list_xml;
 print $template->list_xml;
 print $host    ->list_xml;                           

 # list attributes
 print $vm      ->list;
 print $cluster ->list;
 print $template->list;
 print $host    ->list;

 # create, remove vm
 $vm->create('vm1','Default','CentOS7');
 $vm->remove('2d83bb51-9a77-432d-939c-35be207017b9');
 
 # add/remove/list vm's nic and disk
 
 # start, stop, reboot, migrate vm
 $vm->start     ('b4738b0f-b73d-4a66-baa8-2ba465d63132');
 $vm->stop      ('b4738b0f-b73d-4a66-baa8-2ba465d63132');
 $vm->reboot    ('b4738b0f-b73d-4a66-baa8-2ba465d63132');
 $vm->migrate   ('b4738b0f-b73d-4a66-baa8-2ba465d63132');

 # the output also available in hash
 # for example to print all vm name and state
 my $hash = $vm->hash_output;
 for my $array (keys $hash->{vm}) {
    print $hash->{vm}[$array]->{name} . " " . 
        $hash->{vm}[$array]->{status}->{state};
 }
 
 # we can also specify specific vm 'id' when initiating an object
 # so we can direct access the element for specific vm
 print $vm->hash_output->{name};                   
 print $vm->hash_output->{cluster}->{id};
 
 # Generate display configuration for remote viewer
 my $display = Ovirt::Display->new(%%con);
 print $display->generate();

 sample spice configuration output :
 [virt-viewer]
    type=spice
    host=192.168.1.152
    port=-1
    password=+cnsq458Oq6T
    # Password is valid for 300 seconds.
    tls-port=5902
    fullscreen=0
    title=C1 : %%d - Press SHIFT+F12 to Release Cursor
    enable-smartcard=0
    enable-usb-autoshare=1
    delete-this-file=1
    usb-filter=-1,-1,-1,-1,0
    tls-ciphers=DEFAULT
    host-subject=O=example.com,CN=192.168.1.152
    ca=-----BEGIN CERTIFICATE-----\n -- output removed -- S2fE=\n-----END CERTIFICATE-----\n
    toggle-fullscreen=shift+f11
    release-cursor=shift+f12
    secure-attention=ctrl+alt+end
    secure-channels=main;inputs;cursor;playback;record;display;usbredir;smartcard

 you can save it to a file then use remote viewer to open it:
 $ remote-viewer [your saved file].vv
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/O*

%changelog
