%define module_version 0.11
%define module_name PBS-Client
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(IPC/Open3.pm) perl(Pod/Usage.pm) perl(Symbol.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Perl interface to submit jobs to Portable Batch System (PBS).
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/K/KW/KWMAK/PBS/Client/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module provides a Perl interface to submit jobs to the Portable Batch
System (PBS) server. PBS is a software allocating recources of a network to
batch jobs. This module lets you submit jobs on the fly.

To submit jobs by PBS::Client, you need to prepare two objects: the client
object and the job object. The client object connects to the server and submits
jobs (described by the job object) by the method `qsub'.

The job object specifies various properties of a job (or a group of jobs).
Properties that can be specified includes job name, CPU time, memory, priority,
job inter-dependency and many others.

This module attempts to adopt the same philosophy of Perl, of which it tries
to understand what you want to do and gives you the least surprise. Therefore,
you usually can do the same thing with more than one way. This is also a
reason that makes this document lengthy.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
