# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(PDF/API2.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name PDF-API2-Tweaks
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Assorted handy additions to PDF::API2.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JV/JV/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
PDF::API2::Tweaks provides a number of extensions to PDF::API2.

Most of the extensions deal with producing PDF overlays, to fill in
forms. For example,

    # Open an existing PDF file
    my $pdf = PDF::API2->open($form);

    # Retrieve an existing page
    my $page = $pdf->openpage(1);

    # Add a built-in font to the PDF
    my $font = $pdf->corefont('Helvetica');

    # Setup text context.
    my $text = $page->text();
    $text->font($font, 10);
    $text->fillcolor('#000000');
    $text->strokecolor('#000000');

    # So far, this is all basic PDF::API2.

    # The following Tweaks extension will produce a series of lines,
    # the first one starting at position 100,714 and subsequent lines
    # spaced 16 apart:

    $text->textlist( 100, 714, 16, <<'EOD' );
    Now is the time
    for all good man
    to start using Perl
    EOD

    # Save to a file.
    $pdf->saveas("perl.pdf");
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*

%changelog
