%define module_name PDF-Collage
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Resolver.pm) perl(Image/PNG/Libpng.pm) perl(JSON/PP.pm) perl(Log/Any.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(PDF/Builder.pm) perl(Path/Tiny.pm) perl(Pod/Usage.pm) perl(Template/Perlish.pm) perl(Test/Exception.pm) perl(Test/Pod.pm) perl(autodie.pm) perl(experimental.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: PDF manipulation with scissors and glue
Group: Development/Perl
License: apache
URL: https://codeberg.org/polettix/PDF-Collage

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POLETTIX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`PDF::Collage' helps generate an object wrapping either a
the PDF::Collage::Template manpage or a the PDF::Collage::TemplatesCollection manpage
(collectively referred as *renderable object*).

These allow eventually generate the PDF::Builder manpage objects, after applying
the supported transformations; this allows the generated PDF to be saved
(e.g. using the `saveas' method of the the PDF::Builder manpage object).

The *Do What I Mean* interface the collage entry elsewhere in this document is a one-stop-shop for
getting one such object; it accepts a variety of inputs, including TAR
bundles (or their directory counterparts).

This distribution supports two basic types of inputs:

=over

=item *

*definition* representing single templates, allowing the instantiation
of a the PDF::Collage::Template manpage object;

=item *

*anything* that can be turned into a the Data::Resolver manpage object, leading
to a the PDF::Collage::TemplatesCollection manpage (which, in turn, manages a
collection of the PDF::Collage::Template manpage objects).

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CREDITS.md LICENSE Changes README
%perl_vendor_privlib/P*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
