%define module_version 0.11
%define module_name PDF-Cropmarks
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(Moo.pm) perl(PDF/API2.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(Type/Tiny.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Add cropmarks to existing PDFs
Group: Development/Perl
License: perl
URL: http://amusewiki.org

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MELMOTHX/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module prepares PDF for printing adding the cropmarks, usually on
a larger physical page, doing the same thing the LaTeX package "crop"
does. It also takes care of the paper thickness, shifting the logical
pages to compensate the folding.

It comes with a ready-made script, `pdf-cropmarks.pl'. E.g.

 $ pdf-cropmarks.pl --help # usage
 $ pdf-cropmarks.pl --paper a3 input.pdf output.pdf

To use the module in your code:

  use strict;
  use warnings;
  use PDF::Cropmarks;
  PDF::Cropmarks->new(input => $input,
                      output => $output,
                      paper => $paper,
                      # other options here
                     )->add_cropmarks;

If everything went well (no exceptions thrown), you will find the new
pdf in the output you provided.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/P*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
