%define module_name PDF-Imposition
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Module/Load.pm) perl(Moo.pm) perl(PDF/API2.pm) perl(PDF/Cropmarks.pm) perl(Pod/Usage.pm) perl(Test/LeakTrace.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(Type/Tiny.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.26
Release: alt1
Summary: Perl module to manage the PDF imposition
Group: Development/Perl
License: perl
URL: http://amusewiki.org

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MELMOTHX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is meant to simplify the so-called imposition, i.e.,
rearrange the pages of a PDF to get it ready to be printed and folded,
with more logical pages placed on the sheet, usually (but not
exclusively) on recto and verso.

This is what the routine looks like:

    use PDF::Imposition;
    my $imposer = PDF::Imposition->new(file => "test.pdf",
                                       outfile => "out.pdf",
                                       # or # suffix => "-imposed",
                                       signature => "40-80",
                                       cover => 0,
                                       schema => "2up");
    $imposer->impose;
    print "Output left in " . $imposer->outfile;


Please note that you don't pass the PDF dimensions (which are
extracted from the source PDF itself by the class, using the very
first page: if you want imposition, I do the reasonable assumption you
have all the pages with the same dimensions).

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE Changes README examples
%perl_vendor_privlib/P*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
