# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build/Tiny.pm) perl(PDL.pm) perl(PDL/NiceSlice.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define module_name PDL-ApplyDim
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Conjugate a function with a permutation of the dimensions of an ndarray
Group: Development/Perl
License: perl
URL: https://github.com/wlmb/PDL-ApplyDim

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WL/WLMB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Many operations in PDL act on the first dimension, so a very common
idiom is

    $pdl->mv($dim,0)->function($some, $extra, $args)->mv(0, $dim);

to move the dimension `$dim' to the front, operate with the
function and the move the dimension back to its original place.
The idea is to hide the `mv' operations and write this as

    $pdl->apply_to(\&function, $dim, $some, $extra, $args);

or

    apply_to($pdl, "function", $dim, $some, $extra, $args);

Similarly

    $pdl->apply_not_to(\&function, $dim, $some, $extra, $args);

moves the dimension to the back.

Besides a number, `$dim' may also be an array reference, such as as
=`[$d0, $d1...]', to move the dimensions `$d0, $d1...' to the
front or to the back instead of just a single dimension.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/P*

%changelog
