%define module_name PDL-DSP-Windows
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(PDL.pm) perl(PDL/Graphics/Simple.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.102
Release: alt1
Summary: Window functions for signal processing
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides symmetric and periodic (DFT-symmetric) window functions
for use in filtering and spectral analysis. It provides a high-level access
subroutine the window entry elsewhere in this document. This functional interface is sufficient for getting
the window samples. For analysis and plotting, etc. an object oriented
interface is provided. The functional subroutines must be either explicitly
exported, or fully qualified. In this document, the word *function* refers
only to the mathematical window functions, while the word *subroutine* is
used to describe code.

Window functions are also known as apodization functions or tapering functions.
In this module, each of these functions maps a sequence of `$N' integers to
values called a samples. (To confuse matters, the word *sample* also has
other meanings when describing window functions.) The functions are often
named for authors of journal articles. Be aware that across the literature
and software, some functions referred to by several different names, and some
names refer to several different functions. As a result, the choice of window
names is somewhat arbitrary.

The the kaiser($N,$beta) entry elsewhere in this document window function requires the PDL::GSLSF::BESSEL manpage. The
the dpss($N,$beta) entry elsewhere in this document window function requires the PDL::LinearAlgebra manpage. But the
remaining window functions may be used if these modules are not installed.

The most common and easiest usage of this module is indirect, via some
higher-level filtering interface, such as the PDL::DSP::Fir::Simple manpage. The next
easiest usage is to return a pdl of real-space samples with the subroutine
the window entry elsewhere in this document. Finally, for analyzing window functions, object methods, such as
the new entry elsewhere in this document, the plot entry elsewhere in this document, the plot_freq entry elsewhere in this document are provided.

In the following, first the functional interface (non-object oriented) is
described in the sec...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes CONTRIBUTING examples
%perl_vendor_privlib/P*

%changelog
