%define module_name PDL-Fit-Levmar
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ liblevmar-devel perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(PDL.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0107
Release: alt1
Summary: Nonlinear fit and optimization routines for pdl
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETJ/%{module_name}-%{version}.tar.gz

%description
Levenberg-Marquardt routines for least-squares fit to
functions non-linear in fit parameters.

This module provides a the PDL manpage ( the PDL::PDL manpage ) interface to the non-linear fitting
library levmar 2.5 (written in C). Levmar is
thread aware (in the the PDL manpage sense), provides support for analytic
or finite difference derivatives (in case no analytic
derivatives are supplied), linear and/or box
and/or inequality
constraints (with parameter fixing as a special
case) and pure single or double precision computation. The
routines are re-entrant, so they can be used in
multi-threaded applications (not tested!). Levmar is suited
both for data fitting and for optimization problems.

The source code for the C levmar library is included in this
distribution. However, linearly-constrained fitting requires
that `PDL::Fit::Levmar' be built with support for lapack
and blas libraries. See the files INSTALL and
Makefile.PL, for more information. If
`PDL::Fit::Levmar' is built without support for `lapack',
the fitting options `A', `B', `C', `D', and `FIX' may
not be used. All other options, including `FIXB', do not
require `lapack'.

User supplied fit functions can be written in perl code that
takes pdls as arguments, or, for efficiency, in in a simple
function description language (`lpp'), which is rapidly and
transparently translated to C, compiled, and dynamically
linked.  Fit functions may also be written in pure C.  If C
or `lpp' fit functions are used, the entire fitting
procedure is done in pure compiled C. The compilation and
linking is done only the first time the function is defined.

There is a document distributed with this module
./doc/levmar.pdf by the author of liblevmar describing
the fit algorithms. Additional information on liblevmar is available at
http://www.ics.forth.gr/~lourakis/levmar/

Don't confuse this module with, but see also,  the PDL::Fit::LM manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install
rm -rf %{buildroot}none*
rm -rf %{buildroot}none*

%files
%doc LICENSE TODO README Changes README.pod examples
%perl_vendor_archlib/auto/*
%perl_vendor_archlib/P*

%changelog
