%define module_name PDL-Graphics-Gnuplot
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/gnuplot perl(Alien/Gnuplot.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(IO/Select.pm) perl(IPC/Open3.pm) perl(IPC/Run.pm) perl(List/Util.pm) perl(PDL.pm) perl(PDL/Transform/Color.pm) perl(Safe/Isa.pm) perl(Storable.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.024
Release: alt1
Summary: Gnuplot-based plotting for PDL
Group: Development/Perl
License: perl
URL: http://github.com/PDLPorters/PDL-Graphics-Gnuplot

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows PDL data to be plotted using Gnuplot as a backend
for 2D and 3D plotting and image display.  Gnuplot (not affiliated
with the Gnu project) is a venerable, open-source program that
produces both interactive and publication-quality plots on many
different output devices.  It is available through most Linux
repositories, on MacOS, and from its website
http://www.gnuplot.info.

It is not necessary to understand the gnuplot syntax to generate
basic, or even complex, plots - though the full syntax is available
for advanced users who want the full flexibility of the Gnuplot
backend.

Gnuplot recognizes both hard-copy and interactive plotting devices,
and on interactive devices (like X11) it is possible to pan, scale,
and rotate both 2-D and 3-D plots interactively.  You can also enter
graphical data through mouse clicks on the device window.  On some
hardcopy devices (e.g. "PDF") that support multipage output, it is
necessary to close the device after plotting to ensure a valid file is
written out.

`PDL::Graphics::Gnuplot' exports two routines by default: a
constructor, `gpwin()' and a general purpose plot routine,
`gplot()'.  Depending on options, `gplot()' can produce line plots,
scatterplots, error boxes, "candlesticks", images, or any overlain
combination of these elements; or perspective views of 3-D renderings
such as surface plots.

A call to `gplot()' looks like:

 gplot({temp_plot_options}, # optional hash ref
      curve_options, data, data, ... ,
      curve_options, data, data, ... );

The data entries are columns to be plotted.  They are normally
an optional ordinate and a required abscissa, but some plot modes
can use more columns than that.  The collection of columns is called
a "tuple".  Each column must be a separate PDL or an ARRAY ref.  If
all the columns are PDLs, you can add extra dimensions to make threaded
collections of curves.

PDL::Graphics::Gnuplot also implements an object oriented
interface. Plot objects track individual gnuplot subprocesses.  Direct
calls to `gpl...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CHANGES README.pod examples
%perl_vendor_privlib/P*

%changelog
